//
// F-curve Linker.js
//

// 20120417: first released.
// 20120913: bug fixed.

//

function buildUI( obj ) {
    
    obj.setParameter("name", "F-Curve Linker");
    
    obj.addParameterBool("enabled", 1, 0, 1, false, false);
    
    obj.addParameterSeparator("A");
    
    obj.addParameterLink("A object", true);
    
    obj.addParameterInt("A tag index", -1, -1, 100, false, false);
    obj.addParameterSelector("A parameter", ["position", "rotation", "scale", "other"], false, false);
    obj.addParameterString("A prm. name", "", false);
    obj.addParameterSelector("get for", ["x or h", "y or b", "z or p"], false, false);
    obj.addParameterButton("check A parameters", "check", "checkObjectAInfo");
    
    obj.addParameterSeparator("B");
    
    obj.addParameterLink("B object", true);
    
    obj.addParameterInt("B tag index", -1, -1, 100, false, false);
    obj.addParameterSelector("B parameter", ["position", "rotation", "scale", "other"], false, false);
    obj.addParameterString("B prm. name", "", false);
    obj.addParameterSelector("set for", ["x or h", "y or b", "z or p"], false, false);
    obj.addParameterButton("check B parameters", "check", "checkObjectBInfo");
    
    obj.addParameterSeparator("Conversion");
    
    obj.addParameterSelector("conversion type", ["multiply", "normalize"], false, false);
    obj.addParameterBool("absolute value", 0, 0, 1, true, false);
    obj.addParameterFloat("offset factor", 0, -10000, 10000, true, false);
    obj.addParameterFloat("multiply factor", 1, -10000, 10000, true, false);
    obj.addParameterFloat("normalize min.", 0, -10000, 10000, true, false);
    obj.addParameterFloat("normalize max.", 0, -10000, 10000, true, false);
    
    obj.addParameterSeparator("Checker");
    obj.addParameterFloat("A object val", 0, -10000, 10000, false, false);
    obj.addParameterFloat("B object val", 0, -10000, 10000, false, false);
    
    obj.addParameterSeparator("Bake");
    
    obj.addParameterButton("bake f-curve to B", "bake", "bakeFCurve");
    
}

function tagForType( obj, typeNum ) {
  var returnTag = undefined;
  var len = obj.tagCount();
  for (var i = 0;i < len;i++) {
    var tag = obj.tagAtIndex( i );
    if (tag.type() == typeNum) {
      returnTag = tag;
      break;
    }
  }
  return returnTag;
}

function getParameterTypeForName( obj, name ) {
  var info;
  var infos = obj.parameterInfo();
  var len = infos.length;
  for (var i = 0;i < len;i++) {
    if (infos[i][0] == name) {
      info = infos[i];
    }
  }
  return (info)? info[1] : undefined;
}

function checkObjectAInfo( obj ) {
    var AObj = obj.getParameter("A object");
    var AObjTag = obj.getParameter("A tag index");
    
    if (AObj) {
      var ATarget, BTarget;
      if (AObjTag > -1) {
        ATarget = AObj.tagAtIndex( AObjTag );
      } else {
        ATarget = AObj;
      }
    }
    
    var title = (AObjTag > -1)? "A Object's tag parameters" : "A Object parameters";
    showObjectInfo( ATarget, title );
}

function checkObjectBInfo( obj ) {
    var BObj = obj.getParameter("B object");
    var BObjTag = obj.getParameter("B tag index");

    if (BObj) {
      var BTarget;
      if (BObjTag > -1) {
        BTarget = BObj.tagAtIndex( BObjTag );
      } else {
        BTarget = BObj;
      }
    }
    
    var title = (BObjTag > -1)? "B Object's tag parameters" : "B Object parameters";
    showObjectInfo( BTarget, title );
}

function showObjectInfo( obj, title ) {
  if (!obj) {
    OS.beep();
    return;
  }
  var info = obj.parameterInfo();
  
  var str = '';
  for(var i = 0;i < info.length;i++) {
    str += info[i][0] + " ["+info[i][1]+"] " + "\n";
  }
  
  OS.messageBox( title, str );
}

var DiaRadius = 0.25;
var animTimer = 0;

function buildObject( obj ) {
    
    if ( ! obj.getParameter("enabled") ) return;
        
    var AObj = obj.getParameter("A object");
    var AObjTag = obj.getParameter("A tag index");
    var AObjParam = obj.getParameter("A parameter");
    var AObjParamName = obj.getParameter("A prm. name");
    var AObjAt = obj.getParameter("get for");
    
    var BObj = obj.getParameter("B object");
    var BObjTag = obj.getParameter("B tag index");
    var BObjParam = obj.getParameter("B parameter");
    var BObjParamName = obj.getParameter("B prm. name");
    var BObjAt = obj.getParameter("set for");
    
    var type = obj.getParameter("conversion type");
    var absFlg = obj.getParameter("absolute value");
    var offsetFactor = obj.getParameter("offset factor");
    var multiFactor = obj.getParameter("multiply factor");
    var normalMin = obj.getParameter("normalize min.");
    var normalMax = obj.getParameter("normalize max.");
    
    { // render off
      var tag = tagForType( obj, MODETAG );
      if ( tag ) tag.setParameter("renderActive", false, false);
    }
    
    if (AObj && BObj) {
      var ATarget = getTarget( AObj, AObjTag );
      var BTarget = getTarget( BObj, BObjTag );
      
      switch( AObjParam ) {
        case 0:
          AObjParamName = "position";
          break;
        case 1:
          AObjParamName = "rotation";
          break;
        case 2:
          AObjParamName = "scale";
          break;
      }
      switch( BObjParam ) {
        case 0:
          BObjParamName = "position";
          break;
        case 1:
          BObjParamName = "rotation";
          break;
        case 2:
          BObjParamName = "scale";
          break;
      }
      var fromType = getParameterTypeForName( ATarget, AObjParamName );
      var setType = getParameterTypeForName( BTarget, BObjParamName );
      
      // errorCheck
      if (!fromType || !setType) return;
      
      var fParam = ATarget.getParameter(AObjParamName);
      var param;
      
      switch( AObjAt ) {
        case 0: // x
          param = (fromType == 'Vec2D' || fromType == 'Vec3D' || fromType == 'Vec4D')? fParam.x : fParam;
          break;
        case 1: // y
          param = (fromType == 'Vec2D' || fromType == 'Vec3D' || fromType == 'Vec4D')? fParam.y : fParam;
          break;
        case 2: // z
          param = (fromType == 'Vec3D' || fromType == 'Vec4D')? fParam.z : fParam;
          param = (fromType == 'Vec2D')? fParam.x : param;
          break;
        case 3: // w
          param = (fromType == 'Vec4D')? fParam.w : fParam;
          param = (fromType == 'Vec2D' || fromType == 'Vec3D')? fParam.x : param;
          break;
      }
      
      obj.setParameter("A object val", param, false);
      // conversion
      if (absFlg) param = Math.abs( param );
      
      switch( type ) {
        case 0: // multiply
          param *= multiFactor;
          param += offsetFactor;
          break;
        case 1: // normalize
          param = (param - normalMin) * ( 1 / (normalMax - normalMin) );
          param += offsetFactor;
          break;
      }
      //
      obj.setParameter("B object val", param, false);
      //
      var oldParam, preparedParam;
      
      switch( BObjAt ) {
        case 0: // x
          switch (setType) {
            case 'Vec2D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec2D( param, oldParam.y );
              break;
            case 'Vec3D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec3D( param, oldParam.y, oldParam.z );
              break;
            case 'Vec4D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec4D( param, oldParam.y, oldParam.z, oldParam.w );
              break;
            case 'Bool':
              preparedParam = (param > 0)? true : false;
              break;
            case 'Int':
              preparedParam = Math.floor( param );
              break;
            case 'Float':
              preparedParam = param;
              break;
          }
          break;
        case 1: // y
          switch (setType) {
            case 'Vec2D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec2D( oldParam.x, param );
              break;
            case 'Vec3D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec3D( oldParam.x, param, oldParam.z );
              break;
            case 'Vec4D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec4D( oldParam.x, param, oldParam.z, oldParam.w );
              break;
            case 'Bool':
              preparedParam = (param > 0)? true : false;
              break;
            case 'Int':
              preparedParam = Math.floor( param );
              break;
            case 'Float':
              preparedParam = param;
              break;
          }
          break;
        case 2: // z
          switch (setType) {
            case 'Vec2D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec2D( oldParam.x, oldParam.y );
              break;
            case 'Vec3D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec3D( oldParam.x, oldParam.y, param );
              break;
            case 'Vec4D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec4D( oldParam.x, oldParam.y, param, oldParam.w );
              break;
            case 'Bool':
              preparedParam = (param > 0)? true : false;
              break;
            case 'Int':
              preparedParam = Math.floor( param );
              break;
            case 'Float':
              preparedParam = param;
              break;
          }
          break;
        case 3: // w
          switch (setType) {
            case 'Vec2D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec2D( oldParam.x, oldParam.y );
              break;
            case 'Vec3D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec3D( oldParam.x, oldParam.y, oldParam.z );
              break;
            case 'Vec4D':
              oldParam = BTarget.getParameter(BObjParamName);
              preparedParam = new Vec4D( oldParam.x, oldParam.y, oldParam.z, param );
              break;
            case 'Bool':
              preparedParam = (param > 0)? true : false;
              break;
            case 'Int':
              preparedParam = Math.floor( param );
              break;
            case 'Float':
              preparedParam = param;
              break;
          }
          break;
      }
      
      if (animTimer != obj.document().animPosition()) {
        BTarget.setParameter(BObjParamName, preparedParam, false);  
      } else {
        BTarget.setParameter(BObjParamName, preparedParam, true);
      }
      
      
      //print( BObjParamName + ' : ' + preparedParam );
      
      drawDia( obj.core(), new Mat4D(), 0.5 );
    } else {
      drawDia( obj.core(), new Mat4D(), 0.1 );
    }
    
    animTimer = obj.document().animPosition();
}

function bakeFCurve( obj ) {
  var currentTake = obj.document().currentTake();
  
  var AObj = obj.getParameter("A object");
  var AObjTag = obj.getParameter("A tag index");
  var AObjParam = obj.getParameter("A parameter");
  var AObjParamName = obj.getParameter("A prm. name");
  var AObjAt = obj.getParameter("get for");
  
  var BObj = obj.getParameter("B object");
  var BObjTag = obj.getParameter("B tag index");
  var BObjParam = obj.getParameter("B parameter");
  var BObjParamName = obj.getParameter("B prm. name");
  var BObjAt = obj.getParameter("set for");
  
  var type = obj.getParameter("conversion type");
  var absFlg = obj.getParameter("absolute value");
  var offsetFactor = obj.getParameter("offset factor");
  var multiFactor = obj.getParameter("multiply factor");
  var normalMin = obj.getParameter("normalize min.");
  var normalMax = obj.getParameter("normalize max.");
  
  if (AObj && BObj) {
    var ATarget, BTarget;
    var ATarget = getTarget( AObj, AObjTag );
    var BTarget = getTarget( BObj, BObjTag );
    
    switch( AObjParam ) {
      case 0:
        AObjParamName = "position";
        break;
      case 1:
        AObjParamName = "rotation";
        break;
      case 2:
        AObjParamName = "scale";
        break;
    }
    switch( BObjParam ) {
      case 0:
        BObjParamName = "position";
        break;
      case 1:
        BObjParamName = "rotation";
        break;
      case 2:
        BObjParamName = "scale";
        break;
    }
    var fromType = getParameterTypeForName( ATarget, AObjParamName );
    var setType = getParameterTypeForName( BTarget, BObjParamName );
    
    if (!fromType || !setType) return;
    
    var fParam = ATarget.parameterWithName( AObjParamName );
    var sParam = BTarget.parameterWithName( BObjParamName );
    var param;
    
    var takeNode = fParam.takeNodeWithName( currentTake.name );
    if (takeNode == null) {
      takeNode = fParam.addTakeNode( currentTake.name );
    }
    var setTakeNode = sParam.takeNodeWithName( currentTake.name );
    if (setTakeNode == null) {
      setTakeNode = sParam.addTakeNode( currentTake.name );
    }
    
    if (takeNode && setTakeNode) {
      var fcurve;
      var scurve;
      switch( AObjAt ) {
        case 0:
          fcurve = (fromType == 'Vec2D' || fromType == 'Vec3D' || fromType == 'Vec4D')? takeNode.fCurveAtIndex( 0 ) : takeNode.fCurveAtIndex( 0 );
          break;
        case 1:
          fcurve = (fromType == 'Vec2D' || fromType == 'Vec3D' || fromType == 'Vec4D')? takeNode.fCurveAtIndex( 1 ) : takeNode.fCurveAtIndex( 0 );
          break;
        case 2:
          fcurve = (fromType == 'Vec3D' || fromType == 'Vec4D')? takeNode.fCurveAtIndex( 2 ) : takeNode.fCurveAtIndex( 0 );
          break;
        case 3:
          fcurve = (fromType == 'Vec4D')? takeNode.fCurveAtIndex( 3 ) : takeNode.fCurveAtIndex( 0 );
          break;
      }
      switch( BObjAt ) {
        case 0:
          scurve = (setType == 'Vec2D' || setType == 'Vec3D' || setType == 'Vec4D')? setTakeNode.fCurveAtIndex( 0 ) : setTakeNode.fCurveAtIndex( 0 );
          break;
        case 1:
          scurve = (setType == 'Vec2D' || setType == 'Vec3D' || setType == 'Vec4D')? setTakeNode.fCurveAtIndex( 1 ) : setTakeNode.fCurveAtIndex( 0 );
          break;
        case 2:
          scurve = (setType == 'Vec3D' || setType == 'Vec4D')? setTakeNode.fCurveAtIndex( 2 ) : setTakeNode.fCurveAtIndex( 0 );
          break;
        case 3:
          scurve = (setType == 'Vec4D')? setTakeNode.fCurveAtIndex( 3 ) : setTakeNode.fCurveAtIndex( 0 );
          break;
      }
      
      {
        BTarget.recordParametersForUndo();
        scurve.removeAllKeys();
      }
      
      var count = fcurve.keyCount();
      for (var i = 0;i < count;i++) {
        var key = fcurve.keyAtIndex(i);
        var val = key.value;
        
        if (absFlg) val = Math.abs( val );
        
        switch( type ) {
          case 0:
            val *= multiFactor;
            val += offsetFactor;
            break;
          case 1:
            val = (param - normalMin) * ( 1 / ( normalMax - normalMin) );
            param += offsetFactor;
            break;
        }
        
        key.value = val;
        
        scurve.addKey( key );
      }
      
    obj.setParameter("enabled", false, false);
    }
  }
  
}

function getTarget( obj, ind ) {
  if (ind > -1) {
    if (obj.tagCount() > ind) {
      return obj.tagAtIndex( ind );
    } else {
      return undefined;
    }
  } else {
    return obj;
  }
}

function drawDia( core, mat, length ) {
    
    var radius = DiaRadius * length;
    
    var v0 = core.addVertex( false, mat.multiply( new Vec3D( 0, length, 0 ) ) );
    var v1 = core.addVertex( false, mat.multiply( new Vec3D( 0, radius, -radius * 0.5 ) ) );
    var v2 = core.addVertex( false, mat.multiply( new Vec3D( radius * 0.5, radius, 0 ) ) );
    var v3 = core.addVertex( false, mat.multiply( new Vec3D( 0, radius, radius * 0.5 ) ) );
    var v4 = core.addVertex( false, mat.multiply( new Vec3D( -radius * 0.5, radius, 0 ) ) );
    var v5 = core.addVertex( false, mat.multiply( new Vec3D( 0, 0, 0 ) ) );
    
    core.addIndexPolygon( 3, [ v0, v1, v2 ] );
    core.addIndexPolygon( 3, [ v0, v2, v3 ] );
    core.addIndexPolygon( 3, [ v0, v3, v4 ] );
    core.addIndexPolygon( 3, [ v0, v4, v1 ] );
    core.addIndexPolygon( 3, [ v5, v4, v3 ] );
    core.addIndexPolygon( 3, [ v5, v1, v4 ] );
    core.addIndexPolygon( 3, [ v5, v2, v1 ] );
    core.addIndexPolygon( 3, [ v5, v3, v2 ] );
}